# WeatherWidget Documentation

## Installation

1. Copy the `WeatherWidget` folder to your Matomo `plugins/` directory
2. Activate the plugin in **Administration > Plugins**
3. Add the widget to your dashboard via **Dashboard > Add a widget > Weather > Today's Weather**

## Configuration

All settings are available in **Administration > General Settings** under the **WeatherWidget** section.

### Location Settings

| Setting | Description | Default |
|---------|-------------|---------|
| **Latitude** | Latitude of the location (-90 to 90) | 48.8566 (Paris) |
| **Longitude** | Longitude of the location (-180 to 180) | 2.3522 (Paris) |
| **City name** | Display name shown in the widget | Paris, France |
| **Timezone** | PHP timezone identifier used for the API | Europe/Paris |

You can find the latitude and longitude of any city using [Open-Meteo's geocoding](https://open-meteo.com/en/docs/geocoding-api) or any mapping service.

### Units

| Option | Temperature | Wind Speed |
|--------|-------------|------------|
| **Metric** | °C | km/h |
| **Imperial** | °F | mph |

## Caching

The plugin caches weather data for **30 minutes** using Matomo's Option storage. This means:

- The first request after cache expiry will fetch fresh data from the API
- Subsequent requests within 30 minutes are served instantly from cache
- If the API is unreachable, the plugin will serve stale cached data rather than showing an error

## Data Source

Weather data is provided by the [Open-Meteo API](https://open-meteo.com/), a free and open-source weather API. No API key or registration is required.

The following current weather parameters are displayed:

- Temperature (2m above ground)
- Weather condition (WMO weather code)
- Relative humidity (2m above ground)
- Wind speed (10m above ground)
