# FAQ

## How do I change the displayed city?

Go to **Administration > General Settings**, find the **WeatherWidget** section, and update:

- **Latitude** and **Longitude** — the geographic coordinates of the city
- **City name** — the label displayed in the widget (can be anything)
- **Timezone** — must be a valid PHP timezone identifier (e.g. `Europe/Paris`, `America/New_York`, `Asia/Tokyo`)

## Where can I find coordinates for my city?

You can use any of these methods:

- [Open-Meteo Geocoding API](https://open-meteo.com/en/docs/geocoding-api)
- Search your city on Google Maps and read the coordinates from the URL
- Use any online latitude/longitude lookup tool

## Does this plugin send data to external services?

The plugin makes HTTPS requests to `api.open-meteo.com` to retrieve current weather data. Only the configured latitude, longitude, and timezone are sent as URL query parameters. No personal or analytics data is transmitted.

## How often is the weather data refreshed?

Weather data is cached for 30 minutes. After the cache expires, the next dashboard visit triggers a fresh API call.

## What happens if the weather API is down?

If the API is unreachable, the plugin serves the last successfully cached data. An error is only displayed if no cached data exists at all (e.g. on first use).

## Can I use Fahrenheit instead of Celsius?

Yes. Go to **Administration > General Settings > WeatherWidget** and change the **Units** setting to **Imperial**. This switches to °F for temperature and mph for wind speed.

## Is the widget compatible with dark mode?

Yes. The widget uses CSS custom properties with light-mode fallbacks, so it adapts to both light and dark themes.
