# Weather Widget

Displays current weather on your dashboard with configurable location and units. Powered by Open-Meteo.

> **Warning**
>
> This plugin is experimental and was coded using [Claude Code](https://claude.ai).
> It is provided without any warranty regarding quality, stability, or performance.
> This is a community project and is not officially supported by Matomo.

## Description

Display real-time weather information directly on your dashboard. The widget shows current temperature, weather conditions, humidity, and wind speed for any location in the world.

Powered by the free [Open-Meteo API](https://open-meteo.com/) — no API key required.

### Features

- **Configurable location** — Set any city by latitude/longitude from the admin settings
- **Metric & Imperial units** — Switch between °C/km/h and °F/mph
- **Multilingual** — Weather descriptions are fully translated (English and French included)
- **Smart caching** — API responses are cached for 30 minutes to keep your dashboard fast
- **Graceful degradation** — Serves cached data if the weather API is temporarily unavailable
- **Dark mode compatible** — Uses CSS custom properties for theme support

### How it works

Once activated, add the "Today's Weather" widget to any dashboard. Configure the location and units in **Administration > General Settings > WeatherWidget**.

## Requirements

- Matomo >= 5.0
- PHP >= 8.1

## Installation

### From Matomo Marketplace
1. Go to Administration > Marketplace
2. Search for "WeatherWidget"
3. Click Install

### Manual Installation
1. Download the latest release from GitHub
2. Extract to your `matomo/plugins/` directory
3. Activate the plugin in Administration > Plugins

## Changelog

See [CHANGELOG.md](CHANGELOG.md) or the changelog tab on this page.

## License

GPL-3.0+. See [LICENSE](LICENSE) for details.
