<?php 
/**
 * Plugin Name: Visitor Generator (Matomo Plugin)
 * Plugin URI: http://plugins.matomo.org/VisitorGenerator
 * Description: Developer tool that lets you generate fake visits. Useful if you are working with plugins or themes or if you use the Matomo API.
 * Author: Matomo
 * Author URI: https://matomo.org
 * Version: 5.1.4
 */
?><?php

/**
 * Matomo - free/libre analytics platform
 *
 * @link    https://matomo.org
 * @license http://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 *
 */

namespace Piwik\Plugins\VisitorGenerator;

use Piwik\Plugin;

 
if (defined( 'ABSPATH')
&& function_exists('add_action')) {
    $path = '/matomo/app/core/Plugin.php';
    if (defined('WP_PLUGIN_DIR') && WP_PLUGIN_DIR && file_exists(WP_PLUGIN_DIR . $path)) {
        require_once WP_PLUGIN_DIR . $path;
    } elseif (defined('WPMU_PLUGIN_DIR') && WPMU_PLUGIN_DIR && file_exists(WPMU_PLUGIN_DIR . $path)) {
        require_once WPMU_PLUGIN_DIR . $path;
    } else {
        return;
    }
    add_action('plugins_loaded', function () {
        if (function_exists('matomo_add_plugin')) {
            matomo_add_plugin(__DIR__, __FILE__, true);
        }
    });
}

class VisitorGenerator extends Plugin
{
    public function registerEvents()
    {
        return [
            'Translate.getClientSideTranslationKeys' => 'getClientSideTranslationKeys',
        ];
    }

    public function getClientSideTranslationKeys(&$result)
    {
        $result[] = 'VisitorGenerator_VisitorGenerator';
        $result[] = 'VisitorGenerator_PluginDescription';
        $result[] = 'VisitorGenerator_CliToolUsage';
        $result[] = 'VisitorGenerator_OverwriteLogFiles';
        $result[] = 'VisitorGenerator_DaysToCompute';
        $result[] = 'VisitorGenerator_GenerateFakeActions';
        $result[] = 'VisitorGenerator_AreYouSure';
        $result[] = 'VisitorGenerator_Warning';
        $result[] = 'VisitorGenerator_NotReversible';
        $result[] = 'VisitorGenerator_ChoiceYes';
        $result[] = 'VisitorGenerator_PleaseBePatient';
        $result[] = 'VisitorGenerator_LogImporterNote';
        $result[] = 'VisitorGenerator_Submit';
        $result[] = 'VisitorGenerator_GeneratedVisitsFor';
        $result[] = 'VisitorGenerator_NumberOfGeneratedActions';
        $result[] = 'VisitorGenerator_NbRequestsPerSec';
        $result[] = 'VisitorGenerator_AutomaticReprocess';
        $result[] = 'VisitorGenerator_ReRunArchiveScript';
    }
}
