# Matomo Slack plugin

Deliver the right information to stakeholders automatically, exactly when they need it. Save time with scheduled delivery to Slack channels, email, or mobile instead of manual sharing. Try now - it’s free!

[![Build Status](https://github.com/matomo-org/plugin-Slack/actions/workflows/matomo-tests.yml/badge.svg)](https://github.com/matomo-org/plugin-Slack/actions/workflows/matomo-tests.yml)

## Description

Standard dashboard reports sometimes aren’t enough to keep stakeholders informed. If you need to share insights quickly and make analytics more actionable, **scheduled report delivery** and **custom alerts** ensures no one misses the data that matters most.

With the **Matomo Slack** plugin, you can set up automated reports and tailored alerts directly in Slack. This keeps your team updated, saves time, and makes it easier to monitor changes and respond promptly.

## How the Matomo Slack Plugin Works

### Automate and Deliver Reports Anywhere
- Integrate directly with Slack so your team can access analytics where they already collaborate.
- Schedule delivery daily, weekly, or monthly to suit your reporting cycles.
- Export reports as PDF, CSV or TSV for different use cases.

### Seamless integration with Matomo
- Works across all standard and premium Matomo reports.
- Supports key Matomo features such as [Segments](https://matomo.org/faq/reporting-tools/about-segments-in-matomo/), [Goals](https://matomo.org/faq/reports/create-a-goal-in-matomo/), [Ecommerce](https://matomo.org/faq/reports/set-up-ecommerce-tracking-in-matomo/), and [Funnels](https://matomo.org/faq/reports/create-and-manage-funnels/).

### Managing Features
- Set up Matomo custom alerts and receive notifications in Slack.
- Automate delivery of any Matomo report.
- Share reports via Slack integration.
- Choose from multiple export formats (PDF, CSV or TSV).
- Schedule recurring reports daily, weekly, or monthly.
- Integrates seamlessly with the Matomo platform

## Get the Matomo Slack Plugin Today for Free

Automate the way your organisation shares analytics. With the Slack plugin, your insights will always reach the right people at the right time without manual effort.

## Installation

Install it via Matomo Marketplace

## License

GPL v3 or later