## FAQ

**What is the callback url?**

`http(s)://<YOUR_MATOMO_URL>/index.php?module=RebelOIDC&action=callback&provider=oidc`

**If I have existing users in Matomo, and adding RebelOIDC - how would I handle the existing users?**

In the system settings there is a checkbox to auto link users - activating this, would keep your existing users with the user in the OIDC-provider if they have the same email.

**Which providers can I use?**

I tested the plugin with Auth0, GitHub and Keycloak, which work fine.
If your provider does not seem to work, leave an issue on GitHub.

**How can I unlink all users?**

The easiest way is to fully uninstall the plugin and reinstall afterwards.
Otherwise you can delete data from `matomo_rebeloidc_provider` in your sql database.

If you change the OAuth provider and there could be user id collisions, you should make sure to unlink all users beforehand.

**Can I embed the Login button on another website?**

You have to uncheck the `Disable direct login url` option in the settings.
Afterwards you can link to `http(s)://<YOUR_MATOMO_URL>/index.php?module=RebelOIDC&action=signIn&provider=oidc` and Matomo will redirect the client accordingly.

**Can I setup more than one provider?**

Currently that is **not** possible.
But you can use services like Auth0, which support multiple providers.

**I get a `Can't create table` error when installing the plugin**

Most likely you are using a very old Piwik installation, which still uses MyISAM tables.
Learn here on how to update the database engine:
https://matomo.org/faq/troubleshooting/faq_25610/

**What are the settings for ...?**

- GitHub:

  - Authorize URL: `https://github.com/login/oauth/authorize`
  - Token URL: `https://github.com/login/oauth/access_token`
  - Userinfo URL: `https://api.github.com/user`
  - Userinfo ID: `id`
  - OAuth Scopes: `<EMPTY>`

- Auth0:

  - Authorize URL: `https://<USERNAME>.eu.auth0.com/authorize`
  - Token URL: `https://<USERNAME>.eu.auth0.com/oauth/token`
  - Userinfo URL: `https://<USERNAME>.eu.auth0.com/userinfo`
  - Userinfo ID: `sub`
  - OAuth Scopes: `openid email`


- Keycloak (after 17.x):

  - Authorize URL: `http(s)://<YOUR_KEYCLOAK_URL>/realms/<REALM>/protocol/openid-connect/auth`
  - Token URL: `http(s)://<YOUR_KEYCLOAK_URL>/realms/<REALM>/protocol/openid-connect/token`
  - Userinfo URL: `http(s)://<YOUR_KEYCLOAK_URL>/realms/<REALM>/protocol/openid-connect/userinfo`
  - Logout URL: `http(s)://<YOUR_KEYCLOAK_URL>/realms/<REALM>/protocol/openid-connect/logout?redirect_uri=<MATOMO_URL>`
  - Userinfo ID: `sub`
  - OAuth Scopes: `openid email`

- Keycloak (before 17.x):

  - Authorize URL: `http(s)://<YOUR_KEYCLOAK_URL>/auth/realms/<REALM>/protocol/openid-connect/auth`
  - Token URL: `http(s)://<YOUR_KEYCLOAK_URL>/auth/realms/<REALM>/protocol/openid-connect/token`
  - Userinfo URL: `http(s)://<YOUR_KEYCLOAK_URL>/auth/realms/<REALM>/protocol/openid-connect/userinfo`
  - Logout URL: `http(s)://<YOUR_KEYCLOAK_URL>/auth/realms/<REALM>/protocol/openid-connect/logout?redirect_uri=<MATOMO_URL>`
  - Userinfo ID: `sub`
  - OAuth Scopes: `openid email`

- Gitlab (self-hosted Community Edition 12.6.2):

  - Authorize URL: `http(s)://<YOUR_GITLAB_URL>/oauth/authorize`
  - Token URL: `http(s)://<YOUR_GITLAB_URL>/oauth/token`
  - Userinfo URL: `http(s)://<YOUR_GITLAB_URL>/oauth/userinfo`
  - Userinfo ID: `sub`
  - OAuth Scopes: `openid email`

- Unikname Connect:

  - Name: `Connect with your private @unikname`
  - Authorize URL: `https://connect.unikname.com/oidc/authorize`
  - Token URL: `https://connect.unikname.com/oidc/accessToken`
  - Userinfo URL: `https://connect.unikname.com/oidc/profile`
  - Userinfo ID: `sub`
  - OAuth Scopes: `openid email`

- Microsoft Entra ID:
  - Authorize URL: `https://login.microsoftonline.com/<TENANT_ID>/oauth2/v2.0/authorize`
  - Token URL: `https://login.microsoftonline.com/<TENANT_ID>/oauth2/v2.0/token`
  - Userinfo URL: `https://graph.microsoft.com/oidc/userinfo`
  - Userinfo ID: `sub`
  - OAuth Scopes: `openid email`

- Authentik:
  - Authorize URL: `https://<YOUR_AUTHENTIK_URL>/application/o/authorize/`
  - Token URL: `https://<YOUR_AUTHENTIK_URL>/application/o/token/`
  - Userinfo URL: `https://<YOUR_AUTHENTIK_URL>/application/o/userinfo/`
  - Logout URL: `https://<YOUR_AUTHENTIK_URL>/application/o/<YOUR_AUTHENTIK_APPLICATION_SLUG>/end-session/`
  - Userinfo ID: `sub`
  - Client ID + Secret from Authentik Provider
  - OAuth Scopes: `openid email`

  In the Authentik Provider:
  - Redirect URIs: `.*` (only that worked for me, don't forget the DOT before!)
  Remaining inputs for provider and application as normal.

- Okta:

  - Authorize URL: `https://${yourOktaDomain}/oauth2/v1/authorize`
  - Token URL: `https://${yourOktaDomain}/oauth2/v1/token`
  - Userinfo URL: `https://${yourOktaDomain}/oauth2/v1/userinfo`
  - Userinfo ID: `email`
  - OAuth Scopes: `openid email`

- Authelia
  - Authorize URL: `https://<YOUR_AUTHENTIK_URL>/api/oidc/authorization`
  - Token URL: `https://<YOUR_AUTHENTIK_URL>/api/oidc/token`
  - Userinfo URL: `https://<YOUR_AUTHENTIK_URL>/api/oidc/userinfo`
  - Userinfo ID: `sub`
  - OAuth Scopes: `openid profile email groups`
