<?php 
/**
 * Plugin Name: Mistral AI (Matomo Plugin)
 * Plugin URI: http://plugins.matomo.org/MistralAI
 * Description: Mistral AI support for Matomo
 * Author: Openmost
 * Author URI: https://openmost.io/products/mistral-ai/
 * Version: 5.8.1
 */
?><?php
/**
 * Matomo - free/libre analytics platform
 *
 * @link https://matomo.org
 * @license http://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 */

namespace Piwik\Plugins\MistralAI;

 
if (defined( 'ABSPATH')
&& function_exists('add_action')) {
    $path = '/matomo/app/core/Plugin.php';
    if (defined('WP_PLUGIN_DIR') && WP_PLUGIN_DIR && file_exists(WP_PLUGIN_DIR . $path)) {
        require_once WP_PLUGIN_DIR . $path;
    } elseif (defined('WPMU_PLUGIN_DIR') && WPMU_PLUGIN_DIR && file_exists(WPMU_PLUGIN_DIR . $path)) {
        require_once WPMU_PLUGIN_DIR . $path;
    } else {
        return;
    }
    add_action('plugins_loaded', function () {
        if (function_exists('matomo_add_plugin')) {
            matomo_add_plugin(__DIR__, __FILE__, true);
        }
    });
}

class MistralAI extends \Piwik\Plugin
{

    public function registerEvents()
    {
        return array(
            'AssetManager.getJavaScriptFiles' => 'getJavaScriptFiles',
            'AssetManager.getStylesheetFiles' => 'getStylesheetFiles',
            'Translate.getClientSideTranslationKeys' => 'getClientSideTranslationKeys',
        );
    }

    public function getClientSideTranslationKeys(&$translationKeys)
    {
        $translationKeys[] = 'MistralAI_Insights';
        $translationKeys[] = 'MistralAI_Loading';
        $translationKeys[] = 'MistralAI_Submit';
        $translationKeys[] = 'MistralAI_You';
        $translationKeys[] = 'MistralAI_AI';
        $translationKeys[] = 'MistralAI_ErrorMessage';
        $translationKeys[] = 'MistralAI_MessagePlaceholder';
        $translationKeys[] = 'MistralAI_AskQuestion';
        $translationKeys[] = 'MistralAI_InvalidResponse';
        $translationKeys[] = 'MistralAI_AnErrorOccurred';
        $translationKeys[] = 'MistralAI_NoResponseBody';
        $translationKeys[] = 'MistralAI_WaitingForResponse';
    }

    public function getJavaScriptFiles(&$files)
    {
        if ($this->pluginIsConfigured()) {
            $files[] = "plugins/MistralAI/assets/js/app.js";
        }
    }

    public function getStylesheetFiles(&$files)
    {
        if ($this->pluginIsConfigured()) {
            $files[] = "plugins/MistralAI/assets/css/app.css";
        }
    }

    private function pluginIsConfigured()
    {
        $settings = new \Piwik\Plugins\MistralAI\SystemSettings();
        $host = $settings->host->getValue();
        $apiKey = $settings->apiKey->getValue();
        $model = $settings->model->getValue();

        return $host && $apiKey && $model;
    }
}
