<?php 
/**
 * Plugin Name: Events Enhanced (Matomo Plugin)
 * Plugin URI: http://plugins.matomo.org/EventsEnhanced
 * Description: Add event-based report and event details view
 * Author: Openmost
 * Author URI: https://openmost.io/products/events-enhanced/
 * Version: 1.1.1
 */
?><?php

/**
 * Matomo - free/libre analytics platform
 *
 * @link    https://matomo.org
 * @license https://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 */

namespace Piwik\Plugins\EventsEnhanced;

/**
 * EventsEnhanced plugin - Enhances Matomo native events reports with detailed dimension pages
 *
 * This plugin adds detail pages for each event dimension value (category, action, name).
 * Each detail page shows:
 * - Evolution graph for the dimension value
 * - Reports for related dimensions
 * - Page URLs and titles where events were triggered
 * - Custom dimension reports (if available)
 */
 
if (defined( 'ABSPATH')
&& function_exists('add_action')) {
    $path = '/matomo/app/core/Plugin.php';
    if (defined('WP_PLUGIN_DIR') && WP_PLUGIN_DIR && file_exists(WP_PLUGIN_DIR . $path)) {
        require_once WP_PLUGIN_DIR . $path;
    } elseif (defined('WPMU_PLUGIN_DIR') && WPMU_PLUGIN_DIR && file_exists(WPMU_PLUGIN_DIR . $path)) {
        require_once WPMU_PLUGIN_DIR . $path;
    } else {
        return;
    }
    add_action('plugins_loaded', function () {
        if (function_exists('matomo_add_plugin')) {
            matomo_add_plugin(__DIR__, __FILE__, true);
        }
    });
}

class EventsEnhanced extends \Piwik\Plugin
{
    /**
     * Register plugin events/hooks
     *
     * @return array
     */
    public function registerEvents()
    {
        return [
            'AssetManager.getJavaScriptFiles' => 'getJsFiles',
            'AssetManager.getStylesheetFiles' => 'getStylesheetFiles',
            'Translate.getClientSideTranslationKeys' => 'getClientSideTranslationKeys',
            'Url.getQueryParametersToExclude' => 'getQueryParametersToExclude',
        ];
    }

    /**
     * Exclude our custom parameters from being added to menu links
     * This prevents the eventCategory/eventAction/eventName params from polluting all menu URLs
     *
     * @param array $parametersToExclude
     */
    public function getQueryParametersToExclude(&$parametersToExclude)
    {
        $parametersToExclude[] = 'eventDimensionType';
        $parametersToExclude[] = 'eventDimensionValue';
    }

    /**
     * Register JavaScript files
     *
     * @param array $jsFiles
     */
    public function getJsFiles(&$jsFiles)
    {
        $jsFiles[] = 'plugins/EventsEnhanced/javascripts/eventsEnhancedRowAction.js';
    }

    /**
     * Register stylesheet files
     *
     * @param array $stylesheets
     */
    public function getStylesheetFiles(&$stylesheets)
    {
        $stylesheets[] = 'plugins/EventsEnhanced/stylesheets/eventsEnhanced.less';
    }

    /**
     * Register client-side translation keys
     *
     * @param array $translationKeys
     */
    public function getClientSideTranslationKeys(&$translationKeys)
    {
        // EventsEnhanced translation keys
        $translationKeys[] = 'EventsEnhanced_EventsDetails';
        $translationKeys[] = 'EventsEnhanced_EventDimension';
        $translationKeys[] = 'EventsEnhanced_EventsOverTime';
        $translationKeys[] = 'EventsEnhanced_EventDetailsRowActionTitle';
        $translationKeys[] = 'EventsEnhanced_EventDetailsRowActionDescription';

        // Core Events translation keys (used in dimension selectors and reports)
        $translationKeys[] = 'Events_EventCategory';
        $translationKeys[] = 'Events_EventAction';
        $translationKeys[] = 'Events_EventName';
        $translationKeys[] = 'Events_EventValue';
        $translationKeys[] = 'Events_EventCategories';
        $translationKeys[] = 'Events_EventActions';
        $translationKeys[] = 'Events_EventNames';

        $translationKeys[] = 'Actions_PageUrls';
        $translationKeys[] = 'UserCountry_Country';

        // CustomDimensions translation key (for fallback display)
        $translationKeys[] = 'CustomDimensions_CustomDimensionId';

        // Premium translation keys
        $translationKeys[] = 'EventsEnhanced_PremiumLinkText';
        $translationKeys[] = 'EventsEnhanced_PremiumText';
    }
}
