<?php
/**
 * © 2024 Jorge Powers. All rights reserved.
 *
 * Plugin Name: Data Export (Matomo Plugin)
 * Plugin URI: http://plugins.matomo.org/DataExport
 * Description: Export database or connect to your BI tools.
 * Author: Jorgeuos
 * Author URI: https://jorgeuos.com
 * Version: 1.1.9
 * @link https://jorgeuos.com
 * @license http://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 */

namespace Piwik\Plugins\DataExport;

 
if (defined( 'ABSPATH')
&& function_exists('add_action')) {
    $path = '/matomo/app/core/Plugin.php';
    if (defined('WP_PLUGIN_DIR') && WP_PLUGIN_DIR && file_exists(WP_PLUGIN_DIR . $path)) {
        require_once WP_PLUGIN_DIR . $path;
    } elseif (defined('WPMU_PLUGIN_DIR') && WPMU_PLUGIN_DIR && file_exists(WPMU_PLUGIN_DIR . $path)) {
        require_once WPMU_PLUGIN_DIR . $path;
    } else {
        return;
    }
    add_action('plugins_loaded', function () {
        if (function_exists('matomo_add_plugin')) {
            matomo_add_plugin(__DIR__, __FILE__, true);
        }
    });
}

class DataExport extends \Piwik\Plugin {

    public function registerEvents() {
        return [
            'init' => [$this, 'onInit'],
            'AssetManager.getJavaScriptFiles' => 'getJavaScriptFiles',
            'Translate.getClientSideTranslationKeys' => 'getClientSideTranslationKeys',
        ];
    }

    public function onInit()
    {
        if (file_exists(__DIR__ . '/../vendor/autoload.php')) {
            require_once __DIR__ . '/../vendor/autoload.php';
        }
    }

    public function getJavaScriptFiles(&$jsFiles) {
        $jsFiles[] = 'plugins/DataExport/javascripts/data-export.js';
    }


    public function getClientSideTranslationKeys(&$result)
    {
        $result[] = 'DataExport_CsvCardTitle';
    }

}
