<?php 
/**
 * Plugin Name: Chat GPT (Matomo Plugin)
 * Plugin URI: http://plugins.matomo.org/ChatGPT
 * Description: ChatGPT support for Matomo
 * Author: Openmost
 * Author URI: https://openmost.io/products/chatgpt/
 * Version: 5.4.1
 */
?><?php
/**
 * Matomo - free/libre analytics platform
 *
 * @link https://matomo.org
 * @license http://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 */

namespace Piwik\Plugins\ChatGPT;

 
if (defined( 'ABSPATH')
&& function_exists('add_action')) {
    $path = '/matomo/app/core/Plugin.php';
    if (defined('WP_PLUGIN_DIR') && WP_PLUGIN_DIR && file_exists(WP_PLUGIN_DIR . $path)) {
        require_once WP_PLUGIN_DIR . $path;
    } elseif (defined('WPMU_PLUGIN_DIR') && WPMU_PLUGIN_DIR && file_exists(WPMU_PLUGIN_DIR . $path)) {
        require_once WPMU_PLUGIN_DIR . $path;
    } else {
        return;
    }
    add_action('plugins_loaded', function () {
        if (function_exists('matomo_add_plugin')) {
            matomo_add_plugin(__DIR__, __FILE__, true);
        }
    });
}

class ChatGPT extends \Piwik\Plugin
{

    public function registerEvents()
    {
        return array(
            'AssetManager.getJavaScriptFiles' => 'getJavaScriptFiles',
            'AssetManager.getStylesheetFiles' => 'getStylesheetFiles',
            'Translate.getClientSideTranslationKeys' => 'getClientSideTranslationKeys',
        );
    }

    public function getClientSideTranslationKeys(&$translationKeys)
    {
        $translationKeys[] = 'ChatGPT_Insights';
        $translationKeys[] = 'ChatGPT_Loading';
        $translationKeys[] = 'ChatGPT_Submit';
        $translationKeys[] = 'ChatGPT_You';
        $translationKeys[] = 'ChatGPT_AI';
        $translationKeys[] = 'ChatGPT_ErrorMessage';
        $translationKeys[] = 'ChatGPT_MessagePlaceholder';
        $translationKeys[] = 'ChatGPT_AskQuestion';
        $translationKeys[] = 'ChatGPT_InvalidResponse';
        $translationKeys[] = 'ChatGPT_AnErrorOccurred';
        $translationKeys[] = 'ChatGPT_NoResponseBody';
        $translationKeys[] = 'ChatGPT_WaitingForResponse';
    }

    public function getJavaScriptFiles(&$files)
    {
        if ($this->pluginIsConfigured()) {
            $files[] = "plugins/ChatGPT/assets/js/app.js";
        }
    }

    public function getStylesheetFiles(&$files)
    {
        if ($this->pluginIsConfigured()) {
            $files[] = "plugins/ChatGPT/assets/css/app.css";
        }
    }

    private function pluginIsConfigured()
    {
        $settings = new \Piwik\Plugins\ChatGPT\SystemSettings();
        $host = $settings->host->getValue();
        $apiKey = $settings->apiKey->getValue();
        $model = $settings->model->getValue();

        return $host && $apiKey && $model;
    }
}
